﻿
CREATE PROCEDURE [App].[NVCC_usp_GetXdwFacilityBySta3n]
	@Sta3n smallint

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_GetXdwFacilityBySta3n
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 2017-02-14
--
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To get details about a given site from the Sta3n
--==================================================================================
--Uses: App.udf_StationName
--Uses: CDWWork.Dim.Sta3n

BEGIN
	SELECT
		s.Sta3n AS FacilityID
		,App.udf_StationName(s.Sta3n) AS FacilityName
		,s.VISNFY17 AS VISN
		,s.DistrictNumberFY17 AS District
	FROM CDWWork.Dim.Sta3n AS s
	WHERE 
		s.Sta3n = @Sta3n
END

